//	CDiskUrl.c

#include "CRoseServers.h"
#include "CDiskUrl.h"

OSErr			CDiskUrl::IDiskUrl(
	CDesktop		*desktop, 
	DiskImageRec	*imageRec
) {
	OSErr			err = noErr;
	
	i_itemP	= ImageRec_UrlItem(imageRec).itemP;

	if (!err) err = _inherited::IDisk(desktop, imageRec);
	
	if (!err) {
		if (NewObject(i_rootDir.url, CFolderUrl, err)) {
			err = i_rootDir.url->IFolderUrl(this, NULL, i_itemP, 0);
		}
	}	
	
	return err;
}

Boolean		CDiskUrl::DoCommand(long command)
{
	Boolean		handledB = TRUE;
	
	switch (command) {
		
		case cmdPutAway: {
			CDisk		*thiz;
			Boolean		twirledB = GetTwirled();
			
			Remount(&thiz);
			thiz->SetTwirled(twirledB);
			break;
		}

		default: {
			handledB = _inherited::DoCommand(command);
			break;
		}
	}

	return handledB;
}

void			CDiskUrl::Dismount(void)
{
	_inherited::Dismount();
}	

void			CDiskUrl::Dispose(void)
{
	_inherited::Dispose();
}

char			*CDiskUrl::GetName(char *buf)
{
	_inherited::GetName(buf);
	
	if (buf[0] == 0) {
		Rose_GetName(i_itemP, Gen_Ref_SRC, buf);
		_inherited::SetName(buf);
	}
	
	return buf;
}

char			*CDiskUrl::GetDescription(char *buf)
{
	strcpy(buf, "Rose Server");
	return buf;
}

void			CDiskUrl::Open(void)
{
	gRoseServers->i_generator->Generate(i_itemP);
}

ulong			CDiskUrl::GetVolumeSize(void)
{
	ulong		bytes = 0;
	
	return bytes;
}

ulong		CDiskUrl::GetVolumeMaxFileSize(ushort pro_fileTypeS)
{
	return 0xFFFFFFFF;
}

ulong		CDiskUrl::CalcBytesUsedByFile(ulong fileSize)
{
	return fileSize;
}

ADFS_IconType			CDiskUrl::GetIconType(void)
{
	ADFS_IconType	icon = ADFS_Icon_MOUNT_FOLDER;
	
	return icon;
}


ulong		CDiskUrl::GetVolumeBytesUsed(void)
{
	return 0;
}

/**********************************************************/
DateTimeRec		*CDiskUrl::GetCreatedTime(DateTimeRec *dt)
{
	*dt = i_itemP->resource.source.date;
	
	return dt;
}

void			CDiskUrl::SetCreatedTime(DateTimeRec *dt)
{
	i_itemP->resource.source.date = *dt;
}


DateTimeRec		*CDiskUrl::GetModifiedTime(DateTimeRec *dt)
{
	*dt = i_itemP->resource.dest.date;

	return dt;
}

void			CDiskUrl::SetModifiedTime(DateTimeRec *dt)
{
	i_itemP->resource.dest.date = *dt;
}

/**********************************************************/
DateTimeRec		*CDiskUrl::GetModifiedTimeRemote(DateTimeRec *dt)
{
	return i_rootDir.url->GetModifiedTimeRemote(dt);
}

void			CDiskUrl::RemoteChanged(void)
{
	i_rootDir.url->RemoteChanged();
	DoCommand(cmdPutAway);
}

/**********************************************************/
void			CDiskUrl::GetAccessBits(Gen_AccessBits *bits)
{
	_inherited::GetAccessBits(bits);
}

void			CDiskUrl::SetAccessBits(Gen_AccessBits *bits)
{
	_inherited::SetAccessBits(bits);
}

void			CDiskUrl::SetTwirled(Boolean twirledB)
{
	i_rootDir.url->SetTwirled(twirledB);
	_inherited::SetTwirled(twirledB);
}

Boolean			CDiskUrl::GetTwirled(void)
{
	return i_itemP->b.twirledB;
}

void		CDiskUrl::SetName(char *buf)
{
//	Gen_LinkContent		*contentP = Rose_ResolveRef(i_itemP, Gen_Ref_SRC);

//	Rose_SetText(contentP, buf);
//	_inherited::SetName(buf);
}

Boolean					CDiskUrl::SupportsForks(void)
{
	return TRUE;
}

Boolean			CDiskUrl::IsLocked(void)
{
	Boolean		isLockedB = i_itemP->b.lockedB;

	return isLockedB;
}
